/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class MinimumStockModule
extends AbstractBuildingModule
implements IMinimumStockModule,
IPersistentModule,
ITickingModule,
IAltersRequiredItems {
    private static final int STOCK_PER_LEVEL = 5;
    private static final String TAG_MINIMUM_STOCK = "minstock";
    protected final Map<ItemStorage, Integer> minimumStock = new HashMap<ItemStorage, Integer>();

    private int minimumStockSize() {
        double increase = 1.0 + this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
        return (int)((double)(this.building.getBuildingLevel() * 5) * increase);
    }

    @Override
    public void addMinimumStock(ItemStack itemStack, int quantity) {
        if (this.minimumStock.containsKey(new ItemStorage(itemStack)) || this.minimumStock.size() < this.minimumStockSize()) {
            this.minimumStock.put(new ItemStorage(itemStack), quantity);
            this.markDirty();
        }
    }

    private IToken<?> getMatchingRequest(ItemStack stack, Collection<IToken<?>> list) {
        for (IToken<?> token : list) {
            IRequest<?> iRequest = this.building.getColony().getRequestManager().getRequestForToken(token);
            if (iRequest == null || !(iRequest.getRequest() instanceof Stack) || !((Stack)iRequest.getRequest()).getStack().func_77969_a(stack)) continue;
            return token;
        }
        return null;
    }

    @Override
    public void removeMinimumStock(ItemStack itemStack) {
        this.minimumStock.remove(new ItemStorage(itemStack));
        Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
        IToken<?> token = this.getMatchingRequest(itemStack, list);
        if (token != null) {
            this.building.getColony().getRequestManager().updateRequestState(token, RequestState.CANCELLED);
        }
        this.markDirty();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), this.building.getPosition())) {
            Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
            for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
                ItemStack itemStack = entry.getKey().getItemStack().func_77946_l();
                if (itemStack.func_190926_b()) continue;
                int count = InventoryUtils.hasBuildingEnoughElseCount(this.building, new ItemStorage(itemStack, true), entry.getValue() * itemStack.func_77976_d());
                int delta = entry.getValue() * itemStack.func_77976_d() - count;
                IToken<?> request = this.getMatchingRequest(itemStack, list);
                if (delta > 0) {
                    if (request != null) continue;
                    itemStack.func_190920_e(Math.min(itemStack.func_77976_d(), delta));
                    Stack stack = new Stack(itemStack, false);
                    this.building.createRequest(stack, false);
                    continue;
                }
                if (request == null) continue;
                this.building.getColony().getRequestManager().updateRequestState(request, RequestState.CANCELLED);
            }
        }
    }

    @Override
    public boolean isMinimumStockRequest(IRequest<? extends IDeliverable> request) {
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            if (!(request.getRequest() instanceof Stack) || !((Stack)request.getRequest()).getStack().func_77969_a(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStocked(ItemStack stack) {
        return this.minimumStock.containsKey(new ItemStorage(stack));
    }

    @Override
    public void alterItemsToBeKept(TriConsumer<Predicate<ItemStack>, Integer, Boolean> consumer) {
        if (!this.minimumStock.isEmpty()) {
            for (ItemStorage item : this.minimumStock.keySet()) {
                consumer.accept(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, item.getItemStack(), false, true), (Object)(this.minimumStock.get(item) * item.getItemStack().func_77976_d()), (Object)false);
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.minimumStock.clear();
        ListNBT minimumStockTagList = compound.func_150295_c(TAG_MINIMUM_STOCK, 10);
        for (int i = 0; i < minimumStockTagList.size(); ++i) {
            CompoundNBT compoundNBT = minimumStockTagList.func_150305_b(i);
            this.minimumStock.put(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compoundNBT)), compoundNBT.func_74762_e("quantity"));
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        ListNBT minimumStockTagList = new ListNBT();
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            entry.getKey().getItemStack().func_77955_b(compoundNBT);
            compoundNBT.func_74768_a("quantity", entry.getValue().intValue());
            minimumStockTagList.add((Object)compoundNBT);
        }
        compound.func_218657_a(TAG_MINIMUM_STOCK, (INBT)minimumStockTagList);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeInt(this.minimumStock.size());
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            buf.func_150788_a(entry.getKey().getItemStack());
            buf.writeInt(entry.getValue().intValue());
        }
        buf.writeBoolean(this.minimumStock.size() >= this.minimumStockSize());
    }
}

